/*
 * Decompiled with CFR 0.152.
 */
package frc.emul.vectrex.ui.opengl.shader;

import frc.emul.vectrex.ui.opengl.GLUtils;
import frc.emul.vectrex.ui.opengl.shader.IShaderSource;
import frc.emul.vectrex.ui.opengl.shader.ShaderNotSupportedException;
import java.util.ArrayList;
import java.util.List;
import javax.media.opengl.GL;

public class Shader {
    private final IShaderSource vertSource;
    private final IShaderSource fragSource;
    private boolean fatalUniformMismatches;
    private boolean compiled;
    private int progID;
    private int fragID;
    private int vertID;
    private List<String> mismatches;

    public Shader(IShaderSource iShaderSource, IShaderSource iShaderSource2) {
        this(iShaderSource, iShaderSource2, true);
    }

    public Shader(IShaderSource iShaderSource, IShaderSource iShaderSource2, boolean bl) {
        this.vertSource = iShaderSource;
        this.fragSource = iShaderSource2;
        this.setFatalUniformMismatch(bl);
    }

    public void useShader(GL gL) {
        gL.glUseProgramObjectARB(this.progID);
    }

    public static void useFixedProgram(GL gL) {
        gL.glUseProgramObjectARB(0);
    }

    public void setFatalUniformMismatch(boolean bl) {
        this.fatalUniformMismatches = bl;
    }

    public void setUniform(GL gL, String string, float f) {
        int n = gL.glGetUniformLocationARB(this.progID, string);
        if (n == -1) {
            this.dumpUniformMismatch(string);
            return;
        }
        gL.glUniform1fARB(n, f);
    }

    public void setUniform(GL gL, String string, int n) {
        int n2 = gL.glGetUniformLocationARB(this.progID, string);
        if (n2 == -1) {
            this.dumpUniformMismatch(string);
            return;
        }
        gL.glUniform1iARB(n2, n);
    }

    public boolean recompileShader(GL gL) throws Exception {
        this.releaseShader(gL, false);
        return this.compileShader(gL);
    }

    public boolean compileShader(GL gL) throws Exception {
        if (!this.compiled) {
            if (this.vertID == 0) {
                this.vertID = gL.glCreateShaderObjectARB(35633);
            }
            Shader.compile(gL, this.vertID, this.vertSource);
            if (this.fragID == 0) {
                this.fragID = gL.glCreateShaderObjectARB(35632);
            }
            Shader.compile(gL, this.fragID, this.fragSource);
            if (this.progID == 0) {
                this.progID = gL.glCreateProgramObjectARB();
            }
            gL.glAttachObjectARB(this.progID, this.vertID);
            gL.glAttachObjectARB(this.progID, this.fragID);
            this.compiled = Shader.link(gL, this.progID);
        }
        return this.compiled;
    }

    public void releaseShader(GL gL, boolean bl) throws Exception {
        this.compiled = false;
        if (bl && this.progID != 0) {
            gL.glDeleteObjectARB(this.progID);
            this.progID = 0;
        }
        if (this.vertID != 0) {
            if (this.progID != 0) {
                gL.glDetachObjectARB(this.progID, this.vertID);
            }
            gL.glDeleteObjectARB(this.vertID);
            this.vertID = 0;
        }
        if (this.fragID != 0) {
            if (this.progID != 0) {
                gL.glDetachObjectARB(this.progID, this.fragID);
            }
            gL.glDeleteObjectARB(this.fragID);
            this.fragID = 0;
        }
    }

    private final void dumpUniformMismatch(String string) {
        if (this.fatalUniformMismatches) {
            throw new IllegalArgumentException("Uniform '" + string + "' not found in shader");
        }
        if (this.mismatches == null) {
            this.mismatches = new ArrayList<String>();
        }
        if (!this.mismatches.contains(string)) {
            this.mismatches.add(string);
            System.out.println("*** Uniform '" + string + "' not found in shader");
        }
    }

    private static boolean compile(GL gL, int n, IShaderSource iShaderSource) throws Exception {
        System.out.println("Compiling shader [" + iShaderSource.getID() + "]");
        String string = iShaderSource.getContent();
        gL.glShaderSourceARB(n, 1, new String[]{string}, new int[]{string.length()}, 0);
        gL.glCompileShaderARB(n);
        Shader.checkShaderObjectInfoLog(gL, n, iShaderSource.getID());
        int[] nArray = new int[1];
        gL.glGetObjectParameterivARB(n, 35713, nArray, 0);
        return nArray[0] != 0;
    }

    private static boolean link(GL gL, int n) throws Exception {
        System.out.println("Linking program shader");
        gL.glLinkProgramARB(n);
        Shader.checkShaderObjectInfoLog(gL, n, "Program LINK");
        int[] nArray = new int[1];
        gL.glGetObjectParameterivARB(n, 35714, nArray, 0);
        return nArray[0] != 0;
    }

    private static boolean validate(GL gL, int n) throws Exception {
        System.out.println("Validating program shader");
        gL.glValidateProgramARB(n);
        Shader.checkShaderObjectInfoLog(gL, n, "Program VALIDATION");
        int[] nArray = new int[1];
        gL.glGetObjectParameterivARB(n, 35715, nArray, 0);
        return nArray[0] != 0;
    }

    private static void checkShaderObjectInfoLog(GL gL, int n, String string) {
        int[] nArray = new int[1];
        gL.glGetObjectParameterivARB(n, 35716, nArray, 0);
        int n2 = nArray[0];
        if (n2 > 1) {
            byte[] byArray = new byte[n2];
            gL.glGetInfoLogARB(n, n2, nArray, 0, byArray, 0);
            while (n2 > 0 && byArray[n2 - 1] == 0) {
                --n2;
            }
            System.out.println("_____________________________________________");
            if (string != null) {
                System.out.println("@{ " + string + " }");
            }
            System.out.println(new String(byArray, 0, n2));
            System.out.println("_____________________________________________");
        }
    }

    public static boolean isShadingLanguageSupported(GL gL) {
        return gL.isExtensionAvailable("GL_ARB_shader_objects") && gL.isExtensionAvailable("GL_ARB_vertex_shader") && gL.isExtensionAvailable("GL_ARB_fragment_shader") && gL.isExtensionAvailable("GL_ARB_shading_language_100");
    }

    public static void checkShadingLanguageSupport(GL gL) throws ShaderNotSupportedException {
        String string = "OpenGL Shading Language not available";
        GLUtils.checkExtension(gL, "GL_ARB_shader_objects", string);
        GLUtils.checkExtension(gL, "GL_ARB_vertex_shader", string);
        GLUtils.checkExtension(gL, "GL_ARB_fragment_shader", string);
        GLUtils.checkExtension(gL, "GL_ARB_shading_language_100", string);
    }
}

